import controlP5.*;
import sojamo.drop.*;
import oscP5.*;
import netP5.*;


float fLastTime;

int g_iDataPerByte = 2;
int g_iWavStart = unhex("6000");
int g_iMaxNumInstruments = 8;
int g_iFrameLength = 32;
int g_iNumFrames = 16;
int g_iInstrumentByteLength = 256;
int g_iFrameByteLength = 16;

int g_iMainDrawX = 20;
int g_iMainDrawY = 20;
int g_iMainDrawPixelSize = 10;
Point2D g_MainFrameDrawSize;

SDrop g_Dropper;
ControlP5 g_ControlP5;

SelectionInfo g_SelectionInfo;
DataManager g_DataManager;
WavEditor g_WavEditor;

Frame g_FrameClipboard = new Frame();

Frame g_SawFrame = new Frame();
Frame g_SquareFrame = new Frame();


void setup()
{
  
  size (600, 320);
  smooth();

  g_Dropper = new SDrop(this);
  g_ControlP5 = new ControlP5(this);
   
  initialiseGUI();

  fLastTime = millis();

  g_SelectionInfo = new SelectionInfo();
  g_DataManager = new DataManager();
  g_WavEditor = new WavEditor();
  
  generateFrames();

  //g_DataManager.loadData("lsdj.sav");

}




void draw()
{

  background(200);
  
  g_WavEditor.processMainFrame(g_SelectionInfo);

  processFrameSelection();
  
  displayClipboard();

  if (millis() > (fLastTime + 33))
  {
    fLastTime = millis();
    //process
  }

}



void mousePressed()
{

  g_bMouseDown = true;

}

void mouseReleased()
{

  g_bMouseDown = false;

}

boolean mouseDown()
{
  return g_bMouseDown;
}



void dropEvent(DropEvent theDropEvent) {
  if(theDropEvent.isFile()) {
    // for further information see
    // http://java.sun.com/j2se/1.4.2/docs/api/java/io/File.html
    File myFile = theDropEvent.file();
    println("\nisDirectory ? "+myFile.isDirectory()+"  /  isFile ? "+myFile.isFile());

    println(myFile.toString());

    g_SelectionInfo.setInstrument(0);
    g_SelectionInfo.setFrame(0);

    g_DataManager.loadData(myFile.toString());
  }
}


void keyPressed()
{

  int iFrame = g_SelectionInfo.getFrame();

  if (key == CODED)
  {
    if (keyCode == RIGHT)
    {
      iFrame++;

    }
    else if (keyCode == LEFT)
    {
      iFrame--;
    }
  }

  if (iFrame < 0) iFrame = g_iNumFrames-1;
  if (iFrame > g_iNumFrames-1) iFrame = 0;
  
  g_SelectionInfo.setFrame(iFrame);

}

